﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface IAdditionalWorkerThreadsStrategy
    {
        void Write(List<int> numList);
        List<WFRegistry> Read();
        List<WFRegistry> BackUp();
    }

    public class AdditionalWorkerThreadsDefaultStrategy : ICorrespondenceOS, IAdditionalWorkerThreadsStrategy
    {
        public AdditionalWorkerThreadsDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                         
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName_CWT = "AdditionalCriticalWorkerThreads";
        private string RegName_DWT = "AdditionalDelayedWorkerThreads";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(List<int> numList)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey((
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Executive"));

            registryKey.SetValue(RegName_DWT, numList[1],RegistryValueKind.DWord);
            registryKey.SetValue(RegName_DWT, numList[1], RegistryValueKind.DWord);
        }

        public List<WFRegistry> Read()
        {
            List<WFRegistry> wfRegistries = new List<WFRegistry>();
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Executive");
            if (registryKey != null)
            {
                wfRegistries.AddRange(new[]
                                          {
                                              new WFRegistry(
                                                  @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Executive",
                                                  "AdditionalCriticalWorkerThreads",
                                                  registryKey.GetValue(RegName_CWT, 0),
                                                  RegistryValueKind.DWord,RegOperation.ValueWrite),
                                              new WFRegistry(
                                                  @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Executive",
                                                  "AdditionalCriticalWorkerThreads",
                                                  registryKey.GetValue(RegName_DWT, 0),
                                                  RegistryValueKind.DWord,RegOperation.ValueWrite)
                                          });
                return wfRegistries;
            }
            wfRegistries.AddRange(new[]
                                      {
                                          new WFRegistry(
                                              @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Executive",
                                              RegName_CWT, 0, RegistryValueKind.DWord,RegOperation.ValueWrite),
                                          new WFRegistry(
                                              @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Executive",
                                              RegName_DWT, 0, RegistryValueKind.DWord,RegOperation.ValueWrite)
                                      });

            return wfRegistries;
        }

        public List<WFRegistry> BackUp()
        {
            return Read();
        }

        #endregion
    }

    public class AdditionalWorkerThreadsController
    {
        public AdditionalWorkerThreadsController(AdditionalWorkerThreads additionalWorkerThreads,
                                                 IAdditionalWorkerThreadsStrategy strategy)
        {
            AdditionalWorkerThreads = additionalWorkerThreads;
            Strategy = strategy;
        }

        public AdditionalWorkerThreads AdditionalWorkerThreads { get; set; }
        public IAdditionalWorkerThreadsStrategy Strategy { get; set; }

        public void Read()
        {
            AdditionalWorkerThreads.SetWorkerThreadValue(Strategy.Read());
        }

        public void Write()
        {
            Strategy.Write(AdditionalWorkerThreads.GetWorkerThreadValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}